/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.module;

import io.github.fabricators_of_create.porting_lib.common.util.NonNullConsumer;
import io.github.fabricators_of_create.porting_lib.common.util.NonNullFunction;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.StorageProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3611;
import net.minecraft.class_3913;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.util.WeakConsumerWrapper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuelLookup;
import slimeknights.tconstruct.library.utils.TagUtil;

public class FuelModule
implements class_3913 {
    private static final class_2338 NULL_POS = new class_2338(0, Short.MIN_VALUE, 0);
    public static final int SOLID_TEMPERATURE = 800;
    private final NonNullConsumer<SlottedStorage<FluidVariant>> fluidListener = new WeakConsumerWrapper((Object)this, (self, cap) -> self.reset());
    private final NonNullConsumer<SlottedStorage<ItemVariant>> itemListener = new WeakConsumerWrapper((Object)this, (self, cap) -> self.reset());
    private final MantleBlockEntity parent;
    private final Supplier<List<class_2338>> tankSupplier;
    @Nullable
    private MeltingFuel lastRecipe;
    @Nullable
    private StorageProvider<FluidVariant> fluidHandler;
    @Nullable
    private StorageProvider<ItemVariant> itemHandler;
    private class_2338 lastPos = NULL_POS;
    private List<class_2338> tankDisplayHandlers;
    private final NonNullConsumer<SlottedStorage<FluidVariant>> displayListener = new WeakConsumerWrapper((Object)this, (self, cap) -> {
        if (self.tankDisplayHandlers != null) {
            self.tankDisplayHandlers.remove(cap);
        }
    });
    private int fuel = 0;
    private int fuelQuality = 0;
    private int temperature = 0;
    private final NonNullFunction<Storage<ItemVariant>, Integer> trySolidFuelConsume = handler -> this.trySolidFuel((Storage<ItemVariant>)handler, true);
    private final NonNullFunction<Storage<ItemVariant>, Integer> trySolidFuelNoConsume = handler -> this.trySolidFuel((Storage<ItemVariant>)handler, false);
    private final NonNullFunction<Storage<FluidVariant>, Integer> tryLiquidFuelConsume = handler -> this.tryLiquidFuel((Storage<FluidVariant>)handler, true);
    private final NonNullFunction<Storage<FluidVariant>, Integer> tryLiquidFuelNoConsume = handler -> this.tryLiquidFuel((Storage<FluidVariant>)handler, false);
    private static final String TAG_FUEL = "fuel";
    private static final String TAG_TEMPERATURE = "temperature";
    private static final String TAG_LAST_FUEL = "last_fuel_tank";
    private static final int FUEL = 0;
    private static final int FUEL_QUALITY = 1;
    private static final int TEMPERATURE = 2;
    private static final int LAST_X = 3;
    private static final int LAST_Y = 4;
    private static final int LAST_Z = 5;

    private void reset() {
        this.fluidHandler = null;
        this.itemHandler = null;
        this.tankDisplayHandlers = null;
        this.lastPos = NULL_POS;
    }

    private class_1937 getLevel() {
        return Objects.requireNonNull(this.parent.method_10997(), "Parent tile entity has null world");
    }

    @Nullable
    private MeltingFuel findRecipe(class_3611 fluid) {
        if (this.lastRecipe != null && this.lastRecipe.matches(fluid)) {
            return this.lastRecipe;
        }
        MeltingFuel recipe = MeltingFuelLookup.findFuel(fluid);
        if (recipe != null) {
            this.lastRecipe = recipe;
        }
        return recipe;
    }

    public boolean hasFuel() {
        return this.fuel > 0;
    }

    public void decreaseFuel(int amount) {
        this.fuel = Math.max(0, this.fuel - amount);
        this.parent.setChangedFast();
    }

    private int trySolidFuel(Storage<ItemVariant> handler, boolean consume) {
        for (StorageView view : handler.nonEmptyViews()) {
            int time = 0;
            if (FuelRegistry.INSTANCE.get((class_1935)((ItemVariant)view.getResource()).getItem()) != null) {
                time = (Integer)FuelRegistry.INSTANCE.get((class_1935)((ItemVariant)view.getResource()).getItem()) / 4;
            }
            if (time <= 0) continue;
            if (consume) {
                try (Transaction tx = TransferUtil.getTransaction();){
                    long inserted;
                    ItemVariant resource = (ItemVariant)view.getResource();
                    long extracted = view.extract((Object)((ItemVariant)view.getResource()), 1L, (TransactionContext)tx);
                    this.fuel += time;
                    this.fuelQuality = time;
                    this.temperature = 800;
                    this.parent.setChangedFast();
                    class_1799 container = resource.toStack((int)extracted).getRecipeRemainder();
                    if (!container.method_7960() && (inserted = TransferUtil.insertItem(handler, (class_1799)container)) == 0L) {
                        class_1937 world = this.getLevel();
                        double x = (double)(world.field_9229.method_43057() * 0.5f) + 0.25;
                        double y = (double)(world.field_9229.method_43057() * 0.5f) + 0.25;
                        double z = (double)(world.field_9229.method_43057() * 0.5f) + 0.25;
                        class_2338 pos = this.lastPos == NULL_POS ? this.parent.method_11016() : this.lastPos;
                        class_1542 itementity = new class_1542(world, (double)pos.method_10263() + x, (double)pos.method_10264() + y, (double)pos.method_10260() + z, container);
                        itementity.method_6988();
                        world.method_8649((class_1297)itementity);
                    }
                    tx.commit();
                }
            }
            return 800;
        }
        return 0;
    }

    private NonNullFunction<Storage<ItemVariant>, Integer> trySolidFuel(boolean consume) {
        return consume ? this.trySolidFuelConsume : this.trySolidFuelNoConsume;
    }

    private int tryLiquidFuel(Storage<FluidVariant> handler, boolean consume) {
        FluidStack fluid = TransferUtil.firstOrEmpty(handler);
        MeltingFuel recipe = this.findRecipe(fluid.getFluid());
        if (recipe != null) {
            long amount = recipe.getAmount(fluid.getFluid());
            if (fluid.getAmount() >= amount) {
                if (consume) {
                    try (Transaction tx = TransferUtil.getTransaction();){
                        long drained = handler.extract((Object)fluid.getType(), amount, (TransactionContext)tx);
                        tx.commit();
                        if (drained != amount) {
                            TConstruct.LOG.error("Invalid amount of fuel drained from tank");
                        }
                    }
                    this.fuel += recipe.getDuration();
                    this.fuelQuality = recipe.getDuration();
                    this.temperature = recipe.getTemperature();
                    this.parent.setChangedFast();
                    return this.temperature;
                }
                return recipe.getTemperature();
            }
        }
        return 0;
    }

    private NonNullFunction<Storage<FluidVariant>, Integer> tryLiquidFuel(boolean consume) {
        return consume ? this.tryLiquidFuelConsume : this.tryLiquidFuelNoConsume;
    }

    private int tryFindFuel(class_2338 pos, boolean consume) {
        Storage storage = (Storage)FluidStorage.SIDED.find(this.getLevel(), pos, null);
        Optional<Integer> temperature = Optional.ofNullable(storage).map(this.tryLiquidFuel(consume));
        if (temperature.isPresent()) {
            this.itemHandler = null;
            this.fluidHandler = StorageProvider.createForFluids((class_1937)this.getLevel(), (class_2338)pos);
            this.tankDisplayHandlers = null;
            this.lastPos = pos;
            return temperature.get();
        }
        Storage itemCap = (Storage)ItemStorage.SIDED.find(this.getLevel(), pos, null);
        temperature = Optional.ofNullable(itemCap).map(this.trySolidFuel(consume));
        if (temperature.isPresent()) {
            this.fluidHandler = null;
            this.tankDisplayHandlers = null;
            this.itemHandler = StorageProvider.createForItems((class_1937)this.getLevel(), (class_2338)pos);
            this.lastPos = pos;
            return temperature.get();
        }
        return 0;
    }

    public int findFuel(boolean consume) {
        int posTemp;
        Optional<Object> handlerTemp = Optional.empty();
        if (this.fluidHandler != null) {
            handlerTemp = Optional.ofNullable(this.getFluidStorage()).map(this.tryLiquidFuel(consume));
        } else if (this.itemHandler != null) {
            handlerTemp = Optional.ofNullable(this.getItemStorage()).map(this.trySolidFuel(consume));
        } else if (this.lastPos != NULL_POS && (posTemp = this.tryFindFuel(this.lastPos, consume)) > 0) {
            return posTemp;
        }
        if (handlerTemp.orElse(0) > 0) {
            return (Integer)handlerTemp.get();
        }
        for (class_2338 pos : this.tankSupplier.get()) {
            int posTemp2;
            if (pos.equals((Object)this.lastPos) || (posTemp2 = this.tryFindFuel(pos, consume)) <= 0) continue;
            return posTemp2;
        }
        if (consume) {
            this.temperature = 0;
        }
        return 0;
    }

    public Storage<FluidVariant> getFluidStorage() {
        Storage storage = this.fluidHandler.get(null);
        if (storage == null) {
            this.reset();
        }
        return storage;
    }

    public Storage<ItemVariant> getItemStorage() {
        Storage storage = this.itemHandler.get(null);
        if (storage == null) {
            this.reset();
        }
        return storage;
    }

    public void readFromTag(class_2487 nbt) {
        if (nbt.method_10573(TAG_FUEL, 99)) {
            this.fuel = nbt.method_10550(TAG_FUEL);
        }
        if (nbt.method_10573(TAG_TEMPERATURE, 99)) {
            this.temperature = nbt.method_10550(TAG_TEMPERATURE);
        }
        if (nbt.method_10573(TAG_LAST_FUEL, 99)) {
            this.lastPos = TagUtil.readPos(nbt, TAG_LAST_FUEL);
        }
    }

    public class_2487 writeToTag(class_2487 nbt) {
        nbt.method_10569(TAG_FUEL, this.fuel);
        nbt.method_10569(TAG_TEMPERATURE, this.temperature);
        if (this.lastPos != NULL_POS) {
            nbt.method_10566(TAG_LAST_FUEL, (class_2520)TagUtil.writePos(this.lastPos));
        }
        return nbt;
    }

    public int method_17389() {
        return 6;
    }

    public int method_17390(int index) {
        return switch (index) {
            case 0 -> this.fuel;
            case 1 -> this.fuelQuality;
            case 2 -> this.temperature;
            case 3 -> this.lastPos.method_10263();
            case 4 -> this.lastPos.method_10264();
            case 5 -> this.lastPos.method_10260();
            default -> 0;
        };
    }

    public void method_17391(int index, int value) {
        switch (index) {
            case 0: {
                this.fuel = value;
                break;
            }
            case 1: {
                this.fuelQuality = value;
                break;
            }
            case 2: {
                this.temperature = value;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                switch (index) {
                    case 3: {
                        this.lastPos = new class_2338(value, this.lastPos.method_10264(), this.lastPos.method_10260());
                        break;
                    }
                    case 4: {
                        this.lastPos = new class_2338(this.lastPos.method_10263(), value, this.lastPos.method_10260());
                        break;
                    }
                    case 5: {
                        this.lastPos = new class_2338(this.lastPos.method_10263(), this.lastPos.method_10264(), value);
                    }
                }
                this.fluidHandler = null;
                this.itemHandler = null;
                this.tankDisplayHandlers = null;
            }
        }
    }

    public void clearCachedDisplayListeners() {
        this.tankDisplayHandlers = null;
    }

    public FuelInfo getFuelInfo() {
        List<class_2338> positions = null;
        class_2338 mainTank = this.lastPos;
        if (mainTank.method_10264() == NULL_POS.method_10264()) {
            positions = this.tankSupplier.get();
            if (positions.isEmpty()) {
                return FuelInfo.EMPTY;
            }
            mainTank = positions.get(0);
            assert (mainTank != null);
        }
        if (this.fluidHandler == null && this.itemHandler == null) {
            Storage fluidCap = (Storage)FluidStorage.SIDED.find(this.getLevel(), mainTank, null);
            if (fluidCap != null) {
                this.fluidHandler = StorageProvider.createForFluids((class_1937)this.getLevel(), (class_2338)mainTank);
            } else {
                Storage itemCap = (Storage)ItemStorage.SIDED.find(this.getLevel(), mainTank, null);
                if (itemCap != null) {
                    this.itemHandler = StorageProvider.createForItems((class_1937)this.getLevel(), (class_2338)mainTank);
                }
            }
        }
        if (this.itemHandler != null) {
            return FuelInfo.ITEM;
        }
        FuelInfo info = Optional.ofNullable(this.getFluidStorage()).map(handler -> {
            Iterator iterator = handler.nonEmptyViews().iterator();
            if (iterator.hasNext()) {
                MeltingFuel fuel;
                StorageView view = (StorageView)iterator.next();
                FluidStack fluid = new FluidStack(view);
                int temperature = 0;
                if (!fluid.isEmpty() && (fuel = this.findRecipe(fluid.getFluid())) != null) {
                    temperature = fuel.getTemperature();
                }
                return FuelInfo.of(fluid, view.getCapacity(), temperature);
            }
            return FuelInfo.EMPTY;
        }).orElse(FuelInfo.EMPTY);
        if (!info.isEmpty()) {
            class_1937 world = this.getLevel();
            if (this.tankDisplayHandlers == null) {
                this.tankDisplayHandlers = new ArrayList<class_2338>();
                if (positions == null) {
                    positions = this.tankSupplier.get();
                }
                for (class_2338 pos : positions) {
                    Storage handler2;
                    if (pos.equals((Object)mainTank) || (handler2 = (Storage)FluidStorage.SIDED.find(world, pos, null)) == null) continue;
                    this.tankDisplayHandlers.add(pos);
                }
            }
            FluidStack currentFuel = info.getFluid();
            for (class_2338 pos : this.tankDisplayHandlers) {
                Storage handler3 = (Storage)FluidStorage.SIDED.find(world, pos, null);
                if (handler3 != null) {
                    for (StorageView view : handler3.nonEmptyViews()) {
                        FluidStack fluid = new FluidStack(view);
                        if (fluid.isEmpty()) {
                            info.add(0L, view.getCapacity());
                            continue;
                        }
                        if (!currentFuel.isFluidEqual(fluid)) continue;
                        info.add(fluid.getAmount(), view.getCapacity());
                    }
                    continue;
                }
                this.tankDisplayHandlers.remove(pos);
            }
        }
        return info;
    }

    public FuelModule(MantleBlockEntity parent, Supplier<List<class_2338>> tankSupplier) {
        this.parent = parent;
        this.tankSupplier = tankSupplier;
    }

    public int getFuel() {
        return this.fuel;
    }

    public int getFuelQuality() {
        return this.fuelQuality;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public static class FuelInfo {
        public static final FuelInfo EMPTY = new FuelInfo(FluidStack.EMPTY, 0L, 0L, 0);
        public static final FuelInfo ITEM = new FuelInfo(FluidStack.EMPTY, 0L, 0L, 800);
        private final FluidStack fluid;
        private long totalAmount;
        private long capacity;
        private final int temperature;

        public static FuelInfo of(FluidStack fluid, long capacity, int temperature) {
            if (fluid.isEmpty()) {
                return EMPTY;
            }
            return new FuelInfo(fluid, fluid.getAmount(), Math.max(capacity, fluid.getAmount()), temperature);
        }

        protected void add(long amount, long capacity) {
            this.totalAmount += amount;
            this.capacity += capacity;
        }

        public boolean isItem() {
            return this == ITEM;
        }

        public boolean isEmpty() {
            return this.fluid.isEmpty() || this.totalAmount == 0L || this.capacity == 0L;
        }

        public FluidStack getFluid() {
            return this.fluid;
        }

        public long getTotalAmount() {
            return this.totalAmount;
        }

        public long getCapacity() {
            return this.capacity;
        }

        public int getTemperature() {
            return this.temperature;
        }

        private FuelInfo(FluidStack fluid, long totalAmount, long capacity, int temperature) {
            this.fluid = fluid;
            this.totalAmount = totalAmount;
            this.capacity = capacity;
            this.temperature = temperature;
        }
    }
}

